//
//  Displaying_Long_Lines_of_Text_with_UITextViewViewController.m
//  Displaying Long Lines of Text with UITextView
//
//  Created by Vandad Nahavandipoor on 10/07/2011.
//  Copyright 2011 Pixolity Ltd. All rights reserved.
//

#import "Displaying_Long_Lines_of_Text_with_UITextViewViewController.h"

@implementation Displaying_Long_Lines_of_Text_with_UITextViewViewController

@synthesize myTextView;

- (void)didReceiveMemoryWarning
{
  [super didReceiveMemoryWarning];
  // Usunięcie wszelkich buforowanych danych, obrazów itd., które nie są obecnie używane.
}



#pragma mark - Cykl życiowy widoku

/* 1 */
//- (void)viewDidLoad{
//  [super viewDidLoad];
//  
//  self.view.backgroundColor = [UIColor whiteColor];
//
//  self.myTextView = [[UITextView alloc] initWithFrame:self.view.bounds];
//  self.myTextView.text = @"Miejsce na dowolny tekst...";
//  self.myTextView.font = [UIFont systemFontOfSize:14.0f];
//  [self.view addSubview:self.myTextView];
//  
//}

/* 2 */
- (void) handleKeyboardDidShow:(NSNotification *)paramNotification{
  
  /* Pobranie wielkości klawiatury. */
  NSValue *keyboardRectAsObject = 
    [[paramNotification userInfo]
     objectForKey:UIKeyboardFrameEndUserInfoKey];
  
  /* Umieszczenie danych w strukturze CGRect. */
  CGRect keyboardRect;
  
  [keyboardRectAsObject getValue:&keyboardRect];
  
  /* Zdefiniowanie dolnego marginesu widoku tekstu o takiej wielkości,
   by tekst nie był zasłaniany przez klawiaturę wyświetloną na ekranie. */
  self.myTextView.contentInset = 
    UIEdgeInsetsMake(0.0f,
                     0.0f, 
                     keyboardRect.size.height,
                     0.0f);
}

- (void) handleKeyboardWillHide:(NSNotification *)paramNotification{
  /* Ponowne zwiększenie wymiarów widoku tekstu, aby wypełniał cały ekran. */
  self.myTextView.contentInset = UIEdgeInsetsZero;
}

- (void) viewWillAppear:(BOOL)paramAnimated{
  [super viewWillAppear:paramAnimated];
  
  [[NSNotificationCenter defaultCenter] 
    addObserver:self
       selector:@selector(handleKeyboardDidShow:)
           name:UIKeyboardDidShowNotification
         object:nil];
  
  [[NSNotificationCenter defaultCenter]
    addObserver:self
       selector:@selector(handleKeyboardWillHide:)
           name:UIKeyboardWillHideNotification
         object:nil];
  
  self.view.backgroundColor = [UIColor whiteColor];
  
  self.myTextView = [[UITextView alloc] initWithFrame:self.view.bounds];
  self.myTextView.text = @"Miejsce na dowolny tekst...";
  self.myTextView.font = [UIFont systemFontOfSize:16.0f];
  [self.view addSubview:self.myTextView];
  
}

- (void) viewWillDisappear:(BOOL)paramAnimated{
  [super viewWillDisappear:paramAnimated];
  
  [[NSNotificationCenter defaultCenter] removeObserver:self];
}

- (void)viewDidUnload
{
  [super viewDidUnload];
  // Usunięcie wszystkich "przytrzymanych" podwidoków widoku głównego,
// na przykład self.myOutlet = nil;
}

- (void)viewDidAppear:(BOOL)animated
{
  [super viewDidAppear:animated];
}

- (void)viewDidDisappear:(BOOL)animated
{
	[super viewDidDisappear:animated];
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
  // Zwrot wartości YES dla obsługiwanych układów.
  if ([[UIDevice currentDevice] userInterfaceIdiom] == UIUserInterfaceIdiomPhone) {
    return (interfaceOrientation != UIInterfaceOrientationPortraitUpsideDown);
  } else {
    return YES;
  }
}

@end
